<?php

namespace Placer\PlacingData;

use Placer\Preparer\TpcPreparer;
use Placer\TestCase;

class TpcRegisterPlacingDataTest extends TestCase
{


    public function testTpcRegisterPlacingDataCreation()
    {
        $placingData = new TpcRegisterPlacingData(array(), $this->getPreparer());
        $this->assertInstanceOf('Placer\PlacingData\TpcRegisterPlacingData', $placingData);
    }

    public function testTpcRegisterPlacingDataGetters()
    {
        $input = array(
            'asset_id' => 'PAT-VOD-1',
            'publish_profile' => 'someprofile',
            'audio_languages' => array(
                'US_en'
            ),
            'subtitle_languages' => array(
                'NL_nl'
            ),
            'callback_url' => 'http://somedomain.tld',
            'name' => 'testmetadata',

        );

        $placingData = new TpcRegisterPlacingData($input, $this->getPreparer());
        $this->assertSame($input['asset_id'], $placingData->getId());
        $this->assertSame($input['publish_profile'], $placingData->getPublishProfile());
        $this->assertSame($input['audio_languages'], $placingData->getAudioLanguages());
        $this->assertSame($input['subtitle_languages'], $placingData->getSubtitleLanguages());
        $this->assertSame($input['callback_url'], $placingData->getCallbackUrl());
        $this->assertSame('{"title":"' . $input['name'] . '"}', $placingData->getMetaData());
    }

    public function testTpcRegisterPlacingDataWithInvalidData()
    {
        $placingData = new TpcRegisterPlacingData(array(), $this->getPreparer());
        $this->assertFalse($placingData->isValid());
        $this->assertSame('Missing field asset_id', $placingData->getError());
    }

    public function testTpcRegisterPlacingDataWithValidData()
    {
        $input = array(
            'asset_id' => 'PAT-VOD-1',
            'publish_profile' => 'someprofile',
            'audio_languages' => array(
                'US_en'
            ),
            'subtitle_languages' => array(
                'NL_nl'
            ),
            'callback_url' => 'http://somedomain.tld'

        );
        $placingData = new TpcRegisterPlacingData($input, $this->getPreparer());
        $this->assertTrue($placingData->isValid());
    }

    public function testTpcRegisterPlacingDataWithTrailer()
    {
        $input = array(
            'asset_id' => 'PAT-VOD-1-TRAILER',
        );

        $placingData = new TpcRegisterPlacingData($input, $this->getPreparer());
        $this->assertSame('-1', $placingData->getSubtitleLanguages());
    }

    public function testTpcRegisterPlacingDataWithBurnedInSubs()
    {
        $input = array(
            'burnt_in_subtitles' => true,
        );

        $placingData = new TpcRegisterPlacingData($input, $this->getPreparer());
        $this->assertSame('-1', $placingData->getSubtitleLanguages());
    }

    public function getPreparer()
    {
        return new TpcPreparer('production', 'PAT-VOD');
    }
}
