<?php namespace Placer\Preparer;

use Mockery as m;
use Placer\TestCase;

class TpcPreparerTest extends TestCase {

    public function testTpcPreparerCreationAndInitialisation()
    {
        $preparer = $this->createTpcPreparer('production');

        $this->assertInstanceOf('Placer\Preparer\TpcPreparer', $preparer);
    }

    public function testReturnsAssetOnProduction()
    {
        $preparer = $this->createTpcPreparer('production');

        $asset = $preparer->asset('SOME_ID');

        $this->assertEquals($asset, 'PREFIXSOME_ID');
    }

    public function testReturnsAssetWithLowercaseIdOnProduction()
    {
        $preparer = $this->createTpcPreparer('production');

        $asset = $preparer->asset('some_id');

        $this->assertEquals($asset, 'PREFIXSOME_ID');
    }

    public function testReturnsAssetWithPrefixOnProduction()
    {
        $preparer = $this->createTpcPreparer('production');

        $asset = $preparer->asset('PREFIXSOME_ID');

        $this->assertEquals($asset, 'PREFIXSOME_ID');
    }

    public function testReturnsPrefixOnlyOnProduction()
    {
        $preparer = $this->createTpcPreparer('production');

        $asset = $preparer->asset('');

        $this->assertEquals($asset, 'PREFIX');
    }

    public function testReturnsAssetOnTesting()
    {
        $preparer = $this->createTpcPreparer('testing');

        $asset = $preparer->asset('SOME_ID');

        $this->assertEquals($asset, 'PREFIXSOME_ID-TEST');
    }

    public function testReturnsAssetWithLowercaseIdOnTesting()
    {
        $preparer = $this->createTpcPreparer('testing');

        $asset = $preparer->asset('some_id');

        $this->assertEquals($asset, 'PREFIXSOME_ID-TEST');
    }

    public function testReturnsAssetWithPrefixOnTesting()
    {
        $preparer = $this->createTpcPreparer('testing');

        $asset = $preparer->asset('PREFIXSOME_ID');

        $this->assertEquals($asset, 'PREFIXSOME_ID-TEST');
    }

    public function testReturnsPrefixOnlyOnTesting()
    {
        $preparer = $this->createTpcPreparer('testing');

        $asset = $preparer->asset('');

        $this->assertEquals($asset, 'PREFIX-TEST');
    }

    public function testShouldReturnMetaDataWithFilledTitle()
    {
        $preparer = $this->createTpcPreparer('production');

        $metadata = $preparer->meta_data('isset');
        $json     = json_encode(array('title' => 'isset'));

        $this->assertEquals($metadata, $json);
    }

    public function testShouldReturnMetaDataWithEmptyTitle()
    {
        $preparer = $this->createTpcPreparer('production');

        $metadata = $preparer->meta_data('');
        $json     = json_encode(array('title' => ''));

        $this->assertEquals($metadata, $json);
    }

    public function createTpcPreparer($environment)
    {
        return new TpcPreparer($environment, 'prefix');
    }

}
