<?php namespace Placer\Placing;

use Mockery as m;
use Placer\TestCase;

class TestTpcPlacing extends TestCase {

    public function testTpcPlacingCreation()
    {
        $client  = m::mock('Placer\Client\TpcClient');
        $placing = $this->createTpcPlacing($client);

        $this->assertInstanceOf('Placer\Placing\TpcPlacing', $placing);
    }

    public function testPlacingShouldUpdate()
    {
        $client  = m::mock('Placer\Client\TpcClient');
        $placing = $this->createTpcPlacing($client);

        $this->assertFalse($placing->update());
    }

    /**
     * @expectedException \Placer\Placing\PlacingDataInvalidException
     */
    public function testPlacingDataIsNotValid()
    {
        $client  = m::mock('Placer\Client\TpcClient');
        $placing = $this->createTpcPlacing($client);
        $data    = new \Placer\Stubs\InvalidPlacingData;

        $placing->create($data);
    }

    public function testPlacingDataShouldCreateAndReturnResponse()
    {
        $response = m::mock('Tpc\Connection\ResponseInterface');
        $client   = m::mock('Placer\Client\TpcClient');
        $client->shouldReceive('register')->once()->andReturn($response);

        $placing = $this->createTpcPlacing($client);
        $data    = new \Placer\Stubs\ValidPlacingData;

        $result = $placing->create($data);
        $this->assertInstanceOf('Tpc\Connection\ResponseInterface', $result);
    }

    /**
     * @expectedException \Placer\Placing\NoResultsFoundException
     */
    public function testPlacingShouldNotCreateAndReturnException()
    {
        $client = m::mock('Placer\Client\TpcClient');
        $client->shouldReceive('register')->once()->andReturn(false);
        $client->shouldReceive('get_messages')->once()->andReturn('messages');

        $placing = $this->createTpcPlacing($client);
        $data    = new \Placer\Stubs\ValidPlacingData();

        $placing->create($data);
    }

    public function testShouldGetPlacingStatus()
    {
        $json   = json_encode(array('some', 'json', 'response'));
        $client = m::mock('Placer\Client\TpcClient');
        $client->shouldReceive('getById')->once()->andReturn($json);

        $placing = $this->createTpcPlacing($client);
        $status  = $placing->get(1);

        $this->assertJson($status);
    }

    public function createTpcPlacing($client)
    {
        return new TpcPlacing($client);
    }

}
