<?php namespace Placer\Client;

use Mockery as m;
use Placer\TestCase;
use Placer\PlacingData\TpcRegisterPlacingData;

class TpcClientTest extends TestCase {

    public function testTpcClientCreation()
    {
        $client = $this->createTpcClient();

        $this->assertInstanceOf('Placer\Client\TpcClient', $client);
    }

    public function testReturnsFalseOnUpdate()
    {
        $client = $this->createTpcClient();

        $this->assertFalse($client->update(''));
    }

    public function testReturnsNullWhenGettingEmtpyMessages()
    {
        $client = $this->createTpcClient();

        $this->assertNull($client->get_messages());
    }

    public function createTpcClient()
    {
        $config = m::mock('Placer\Config\TpcConfig');
        $config->shouldIgnoreMissing('getApiUrl');
        $config->shouldIgnoreMissing('getApiKey');
        $config->shouldIgnoreMissing('getApiSecret');
        $config->shouldIgnoreMissing('getCachePath');
        $logger = m::mock('Placer\LoggerInterface');

        return new TpcClient($config, $logger);
    }

}
