<?php

namespace Placer\PlacingData;

use Placer\Preparer\PreparerInterface;

class TpcRegisterPlacingData implements RegisterPlacingDataInterface {

	protected $asset_id;
	protected $publish_profile;
	protected $subtitle_languages = array();
	protected $audio_languages = array();
	protected $callback_url;
	protected $name;
	
	protected $_preparer;
	protected $_required_fields = array('asset_id', 'publish_profile', 'audio_languages', 'callback_url');
	protected $_error;
	
	public function __construct(array $data, PreparerInterface $preparer)
	{
		foreach ($data as $key => $value)
		{
			if (property_exists($this, $key) AND substr($key, 0, 1) != '_')
			{
				$this->$key = $value;
			}
		}
		
		$this->_preparer = $preparer;
	}
	
	/**
	 * Checks if all the required fields are there
	 * 
	 * @return boolean
	 */
	public function isValid()
	{
		foreach ($this->_required_fields as $field)
		{
			if (empty($this->$field))
			{
				$this->_error = 'Missing field ' . $field;
				return FALSE;
			}
		}
		
		return TRUE;
	}

	public function getId()
	{
		return $this->_preparer->asset($this->asset_id);
	}
	
	public function getPublishProfile()
	{
		return $this->publish_profile;
	}
	
	public function getAudioLanguages()
	{
		return $this->_preparer->audio_lang($this->audio_languages);
	}
	
	public function getSubtitleLanguages()
	{
		if (strpos($this->asset_id, 'TRAILER') === FALSE)
		{
			return $this->_preparer->sub_lang($this->subtitle_languages);
		}
		else
		{
			return '-1';
		}
	}
	
	public function getMetaData()
	{
		return $this->_preparer->meta_data($this->name);
	}
	
	public function getCallbackUrl()
	{
		return $this->callback_url;
	}
	
	public function getError()
	{
		return $this->_error;
	}
}
