<?php

namespace Placer\PlacingData;

interface RegisterPlacingDataInterface {

	/**
	 * @return int Asset_Id
	 */
	public function getId();
	
	/**
	 * @return string Placing Profile
	 */
	public function getPublishProfile();
	
	/**
	 * @return array Asset Audio Languages
	 */
	public function getAudioLanguages();

	/**
	 * @return array Asset Subtitle Languages
	 */
	public function getSubtitleLanguages();
	
	/**
	 * @return boolean
	 */
	public function isValid();
	
	/**
	 * @return string Error message
	 */
	public function getError();
}
