<?php

namespace Placer\Placing;

use Placer\Client\TpcClient;
use Placer\PlacingData\RegisterPlacingDataInterface;

class TpcPlacing extends AbstractPlacing {

	public function __construct(TpcClient $client)
	{
		$this->client = $client;
	}

	public function update()
	{
        return false;
	}

	public function create(RegisterPlacingDataInterface $placing_data)
	{
		if ( ! $placing_data->isValid())
		{
			throw new PlacingDataInvalidException($placing_data->getError());
		}
		else
		{
            $result = $this->client->register($placing_data);

            if (FALSE === $result)
			{
				throw new NoResultsFoundException($this->client->get_messages());
			}
			else
			{
				return $result;
			}
		}
	}

	public function get($placing_id)
	{
		return $this->client->getById($placing_id);
	}

}
