<?php

declare (strict_types = 1);

namespace IssetBV\Json\Exception;

use Exception;

/**
 * Class InvalidPropertyAccessException.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class InvalidPropertyAccessException extends Exception
{
    /**
     * InvalidPropertyAccessException constructor.
     *
     * @param string $property
     * @param mixed $object
     */
    public function __construct($property, $object)
    {
        parent::__construct(sprintf('Unable to access property %s on %s', $property, get_class($object)));
    }
}
