<?php

declare (strict_types = 1);

namespace IssetBV\Json;

use ArrayAccess;
use Countable;
use IteratorAggregate;

/**
 * Class JsonThing.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface JsonThing extends IteratorAggregate, ArrayAccess, Countable
{
    /**
     * @param string $propertyName
     *
     * @return bool
     */
    public function hasProperty(string $propertyName) : bool;
}
