----------------------------
Object Oriented Json Decoder
----------------------------

# Example


```json
{
	"books": [
		{
			"title": "Free Will",
			"year": 2012,
			"author": "Sam Harris",
			"isbn": "ISBN 978-1451683400"
		},
		{
			"title": "Lying",
			"year": 2011,
			"author": "Sam Harris",
			"isbn": "ISBN 978-1940051000"
		}
	]
}
```

```php
<?php

try {
	$decoder = new SimpleDecoder();
	$document = $decoder->decode($json);

	if ($document->hasProperty('books')) {
		$books = $document['books']; // Array access is supported for objects
		$books = $document->books; // But object access looks nicer
		
		foreach ($books as $book) {
			echo $book->title; // Again property access through -> works as well.
		}

		$firstIsbn = $books[0]['isbn'];
	}

	$bookCount = count($books); // 2
	
} catch (DecodeException $e) {
	// Thrown in case the decode functions fails	
} catch (InvalidPropertyAccessException $e) {
	// Thrown in case you're trying to access an attribute or array key that doesn't exist. 
} catch (UnsupportedOperationException $e) {
    // Thrown if you're trying to edit the object
}
```


## UnsupportedOperationException

The decode function will wrap objects in `JsonObject`s and arrays in 
`JsonArray`s. These two objects are implement interfaces that make them 
seem mutable but they are not. An `UnsupportedOperationException` will 
be thrown if you're tyring to edit these read only objects. This is not
an exception that you should be check for. You're supposed to be in 
control of this.

## InvalidPropertyAccessException

The design goal of the library is that it allows you to write code 
assuming that the JSON you receive from some external service is in a 
specific format. If there are any optional properties you should use
`hasProperty` to see if these are present. You can simply read
non-optional properties as if they exist and handle the exceptions
in case they don't.

## DecodeException

This exception is thrown if the json could not be parsed properly. This
is kinda nice because now you wont have to call `json_last_error` all
the time.

# Changelog

Version 2.0 is updated for PHP7