<?php

namespace IssetBV\Json;

/**
 * Class Inspector
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class Inspector
{

    /**
     * @param mixed $data
     * @return JsonThing|string|float|int|bool|null
     */
    public static function parseData($data)
    {
        if (is_array($data)) {
            return Inspector::parseArray($data);
        } elseif (is_string($data)) {
            return (string)$data;
        } elseif (is_int($data)) {
            return (int)$data;
        } elseif (is_bool($data)) {
            return (bool)$data;
        } elseif (is_float($data)) {
            return (float)$data;
        } elseif (null === $data) {
            return null;
        }

        return null;
    }

    /**
     * @param array $data
     * @return JsonThing
     */
    private static function parseArray(array $data)
    {
        $keys = array_keys($data);

        $isArray = true;
        $counter = 0;
        foreach ($keys as $key) {
            if ($key !== $counter++) {
                $isArray = false;
                break;
            }
        }

        if ($isArray) {
            $convertedData = [];
            foreach ($data as $dataElement) {
                $convertedData[] = Inspector::parseData($dataElement);
            }

            return new JsonArray($convertedData);
        } else {
            $convertedData = [];
            foreach ($data as $property => $dataElement) {
                $convertedData[$property] = Inspector::parseData($dataElement);
            }

            return new JsonObject($convertedData);
        }
    }
}