----------------------------
Object Oriented Json Decoder
----------------------------

# Example


```json
{
	"books": [
		{
			"title": "Free Will",
			"year": 2012,
			"author": "Sam Harris"
			"isbn": "ISBN 978-1451683400"
		},
		{
			"title": "Lying"
			"year": 2011,
			"author": "Sam Harris",
			"isbn": "ISBN 978-1940051000"
		}
	]
}
```

```php
<?php

try {
	$decoder = new SimpleDecoder();
	$document = $decoder->decode($json);

	if ($document->hasProperty('books')) {
		$books = $document['books']; // $document->books is also supported for objects

		foreach ($books as $book) {
			echo $book['title']; // Again property access through -> works as well.
		}

		$firstIsbn = $books[0]['isbn'];
	}

	$bookCount = count($books); // 2
	
} catch (DecodeException $e) {
	// Trown in case the decode functions fails	
} catch (InvalidPropertyAccessException $e) {
	// Trown in case you're trying to access an attribute or array key that doesn't exist. 
}

```