<?php

require_once '../vendor/autoload.php';

use IssetBV\Json\SimpleDecoder;

$json = <<<'EOD'
{
    "streams": [
        {
            "index": 0,
            "codec_name": "h264",
            "codec_long_name": "H.264 / AVC / MPEG-4 AVC / MPEG-4 part 10",
            "profile": "Main",
            "codec_type": "video",
            "codec_time_base": "1/48000",
            "codec_tag_string": "avc1",
            "codec_tag": "0x31637661",
            "width": 1920,
            "height": 1056,
            "has_b_frames": 0,
            "sample_aspect_ratio": "0:1",
            "display_aspect_ratio": "0:1",
            "pix_fmt": "yuv420p",
            "level": 40,
            "color_range": "tv",
            "color_space": "bt709",
            "color_transfer": "bt709",
            "color_primaries": "bt709",
            "chroma_location": "topleft",
            "refs": 2,
            "is_avc": "1",
            "nal_length_size": "4",
            "r_frame_rate": "24000/1001",
            "avg_frame_rate": "24000/1001",
            "time_base": "1/24000",
            "start_pts": 0,
            "start_time": "0.000000",
            "duration_ts": 3608605,
            "duration": "150.358542",
            "bit_rate": "9735236",
            "bits_per_raw_sample": "8",
            "nb_frames": "3605",
            "disposition": {
                "default": 1,
                "dub": 0,
                "original": 0,
                "comment": 0,
                "lyrics": 0,
                "karaoke": 0,
                "forced": 0,
                "hearing_impaired": 0,
                "visual_impaired": 0,
                "clean_effects": 0,
                "attached_pic": 0
            },
            "tags": {
                "creation_time": "2015-04-20 19:31:53",
                "language": "eng",
                "handler_name": "Apple Video Media Handler",
                "encoder": "H.264"
            }
        },
        {
            "index": 1,
            "codec_type": "data",
            "codec_time_base": "1/24",
            "codec_tag_string": "tmcd",
            "codec_tag": "0x64636d74",
            "r_frame_rate": "0/0",
            "avg_frame_rate": "0/0",
            "time_base": "1/24000",
            "start_pts": 0,
            "start_time": "0.000000",
            "duration_ts": 3608605,
            "duration": "150.358542",
            "bit_rate": "3",
            "nb_frames": "15",
            "disposition": {
                "default": 1,
                "dub": 0,
                "original": 0,
                "comment": 0,
                "lyrics": 0,
                "karaoke": 0,
                "forced": 0,
                "hearing_impaired": 0,
                "visual_impaired": 0,
                "clean_effects": 0,
                "attached_pic": 0
            },
            "tags": {
                "creation_time": "2015-04-20 19:31:53",
                "language": "eng",
                "handler_name": "Time Code Media Handler",
                "reel_name": "untitled",
                "timecode": "01:00:00:00"
            }
        },
        {
            "index": 2,
            "codec_name": "aac",
            "codec_long_name": "AAC (Advanced Audio Coding)",
            "profile": "LC",
            "codec_type": "audio",
            "codec_time_base": "1/44100",
            "codec_tag_string": "mp4a",
            "codec_tag": "0x6134706d",
            "sample_fmt": "fltp",
            "sample_rate": "44100",
            "channels": 2,
            "channel_layout": "stereo",
            "bits_per_sample": 0,
            "r_frame_rate": "0/0",
            "avg_frame_rate": "0/0",
            "time_base": "1/44100",
            "start_pts": 0,
            "start_time": "0.000000",
            "duration_ts": 6631424,
            "duration": "150.372426",
            "bit_rate": "124465",
            "nb_frames": "6476",
            "disposition": {
                "default": 1,
                "dub": 0,
                "original": 0,
                "comment": 0,
                "lyrics": 0,
                "karaoke": 0,
                "forced": 0,
                "hearing_impaired": 0,
                "visual_impaired": 0,
                "clean_effects": 0,
                "attached_pic": 0
            },
            "tags": {
                "creation_time": "2015-04-20 19:31:53",
                "language": "eng",
                "handler_name": "Apple Sound Media Handler"
            }
        }
    ],
    "format": {
        "filename": "/home/transfer/ftp/99dd4a58-8249-4b51-ab5e-468f6890e7d4.mov",
        "nb_streams": 3,
        "nb_programs": 0,
        "format_name": "mov,mp4,m4a,3gp,3g2,mj2",
        "format_long_name": "QuickTime / MOV",
        "start_time": "0.000000",
        "duration": "150.358542",
        "size": "185408064",
        "bit_rate": "9864850",
        "probe_score": 100,
        "tags": {
            "major_brand": "qt  ",
            "minor_version": "537199360",
            "compatible_brands": "qt  ",
            "creation_time": "2015-04-20 19:31:53",
            "timecode": "01:00:00:00"
        }
    }
}
EOD;

$decoder = new SimpleDecoder();

$decoded = $decoder->decode($json);

if (false === $decoded->hasProperty('streams')) {
    echo 'no streams';
}

if (false === $decoded->hasProperty('format')) {
    echo 'no format';
}

foreach ($decoded['streams'] as $stream) {
    dump($stream['time_base']); //throws
}


