<?php

namespace IssetBV\Json;
use IssetBV\Json\Exception\DecodeException;

/**
 * Class SimpleDecoder
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SimpleDecoder implements Decoder
{

    /**
     * @param string $data
     *
     * @return JsonThing
     * @throws DecodeException
     */
    public function decode($data)
    {
        $data = json_decode($data, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new DecodeException(json_last_error_msg(), json_last_error());
        }

        return Inspector::__magic($data);
    }
}