<?php
namespace IssetBV\NginxAclBundle\Service;

use DateTime;
use LogicException;
class NginxAcl
{

    /**
     * @var string
     */
    private $buildString;

    /**
     * @var string
     */
    private $secret;

    /**
     * @var string
     */
    private $queryToken;

    /**
     * @var string
     */
    private $queryExpires;

    public function __construct($buildString, $secret, $queryToken, $queryExpires)
    {
        $this->buildString = $buildString;
        $this->secret = $secret;
        $this->queryExpires = $queryExpires;
        $this->queryToken = $queryToken;
    }

    public function secureUrl($url, DateTime $expires, $remoteAddr = null)
    {
        $data = parse_url($url);
        $remoteAddr = $data['host'];
        $token = $this->generateToken($expires, $data['path'], $remoteAddr);
        
        return $url . (strpos($url, '?') === false ? '?' : '&') . $this->queryToken . '=' . $token . '&' . $this->queryExpires . '=' . $expires->getTimestamp();
    }

    public function generateToken(DateTime $expires, $uri, $remoteAddr = null, $buildString = null, $secret = null)
    {
        if ($buildString === null) {
            $buildString = $this->buildString;
        }
        
        if ($secret === null) {
            $secret = $this->secret;
        }
        
        if($secret === null){
            throw new LogicException('Cannot use empty secret');
        }
        
        if($buildString === null){
            throw new LogicException('Cannot use blank buildstring');
        }
        
        $secure = str_replace([
            '::expires::',
            '::uri::',
            '::remote::',
            '::secret::'
        ], [
            $expires->getTimestamp(),
            $uri,
            $remoteAddr,
            $secret
        ], $buildString);
        $token = base64_encode($this->md5bin($secure));
        return str_replace(array(
            '+',
            '/',
            '='
        ), array(
            '-',
            '_',
            ''
        ), $token);
    }

    public function md5bin($target)
    {
        $md5 = md5($target);
        $ret = '';
        
        for ($i = 0; $i < 32; $i += 2) {
            $ret .= chr(hexdec($md5{$i + 1}) + hexdec($md5{$i}) * 16);
        }
        
        return $ret;
    }
}


