<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\XAuthBundle\DependencyInjection;

use IssetBV\MyIsset\XAuthBundle\Service\Security\UserAuthenticator;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetXAuthExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $definition = $container->register(UserAuthenticator::class);
        $definition->setArgument('$tokens', $config['tokens']);
    }

    public function getAlias(): string
    {
        return 'myisset_xauth';
    }
}
