<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\XAuthBundle\Service\Client;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProvider;

class XAuthUrlProvider
{
    /**
     * @var MyIssetUrlProvider
     */
    private $urlProvider;

    public function __construct(MyIssetUrlProvider $urlProvider)
    {
        $this->urlProvider = $urlProvider;
    }

    public function createAccountUrl(): string
    {
        return $this->urlProvider->getBaseUrl() . 'api/xauth/account';
    }

    public function createLoginUrl(): string
    {
        return $this->urlProvider->getBaseUrl() . 'api/xauth/login';
    }
}
