<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\XAuthBundle\Service\Security;

use Exception;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Http\Authentication\SimplePreAuthenticatorInterface;

class UserAuthenticator implements SimplePreAuthenticatorInterface
{
    /**
     * @var string[]
     */
    private $tokens;

    public function __construct(array $tokens)
    {
        $this->tokens = $tokens;
    }

    public function authenticateToken(TokenInterface $token, UserProviderInterface $userProvider, $providerKey)
    {
        $apiKey = $token->getCredentials();
        try {
            $user = $userProvider->loadUserByUsername($apiKey);
            $return = new UserToken($user, $apiKey, $providerKey, $user->getRoles());
            $return->setAuthenticated(true);

            return $return;
        } catch (Exception $e) {
            throw new HttpException(401, 'API key invalid');
        }
    }

    public function createToken(Request $request, $providerKey): UserToken
    {
        $apiKey = null;
        foreach ($this->tokens as $token) {
            if (!$request->headers->has($token)) {
                continue;
            }
            $apiKey = $request->headers->get($token);
            break;
        }
        if (null === $apiKey) {
            throw new HttpException(401, 'No API key found tokens accepted: [' . implode(', ', $this->tokens) . ']');
        }

        return new UserToken('anon.', $apiKey, $providerKey);
    }

    public function supportsToken(TokenInterface $token, $providerKey): bool
    {
        return $token instanceof UserToken && $token->getProviderKey() === $providerKey;
    }
}
