<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\XAuthBundle\Controller;

use IssetBV\MyIsset\XAuthBundle\Service\Client\Client;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class AuthenticationController extends Controller
{
    /**
     * @param Request $request
     * @param Client $client
     *
     * @return Response
     */
    public function loginAction(Request $request, Client $client): Response
    {
        $response = $client->login($request->request->all());

        return new Response($response->getBody(), $response->getStatusCode(), ['Content-Type' => 'application/json']);
    }
}
