<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\XAuthBundle\Service\Client;

use IssetBV\Http\Client\ClientInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientDataGenerator;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientData;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientInterface;
use Psr\Http\Message\ResponseInterface;

class Client implements UserProviderClientInterface
{
    /**
     * @var ClientInterface
     */
    private $client;
    /**
     * @var XAuthUrlProvider
     */
    private $XAuthUrlProvider;
    /**
     * @var ClientDataGenerator
     */
    private $clientDataGenerator;

    public function __construct(ClientInterface $client, XAuthUrlProvider $XAuthUrlProvider, ClientDataGenerator $clientDataGenerator)
    {
        $this->client = $client;
        $this->XAuthUrlProvider = $XAuthUrlProvider;
        $this->clientDataGenerator = $clientDataGenerator;
    }

    /**
     * @param string $token
     *
     * @throws AccountNotFound
     *
     * @return UserProviderClientData
     */
    public function getAccount(string $token): UserProviderClientData
    {
        $url = $this->XAuthUrlProvider->createAccountUrl();
        $request = $this->client->getRequestGenerator()->create('GET', $url, ['x-auth-token' => $token]);
        $response = $this->client->call($request);

        return $this->clientDataGenerator->fromResponse($response);
    }

    /**
     * @param array $data
     *
     * @return ResponseInterface
     */
    public function login(array $data): ResponseInterface
    {
        $multiPartData = [];
        foreach ($data as $key => $value) {
            $multiPartData[] = [
                'name' => $key,
                'contents' => $value,
            ];
        }
        $url = $this->XAuthUrlProvider->createLoginUrl();
        $stream = $this->client->getStreamGenerator()->createMultiPartStream($multiPartData);
        $request = $this->client->getRequestGenerator()->create('POST', $url, [], $stream);

        return $this->client->call($request);
    }
}
