<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\XAuthBundle\Service\Security;

use Exception;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Http\Authentication\SimplePreAuthenticatorInterface;

class UserAuthenticator implements SimplePreAuthenticatorInterface
{

    /**
     * @var string
     */
    private $tokenName;

    /**
     * UserAuthenticator constructor.
     * @param string $tokenName
     */
    public function __construct(string $tokenName)
    {
        $this->tokenName = $tokenName;
    }

    public function authenticateToken(TokenInterface $token, UserProviderInterface $userProvider, $providerKey)
    {
        $apiKey = $token->getCredentials();
        try {
            $user = $userProvider->loadUserByUsername($apiKey);
            $return = new UserToken($user, $apiKey, $providerKey, $user->getRoles());
            $return->setAuthenticated(true);
            return $return;
        } catch (Exception $e) {
            throw new HttpException(403, 'API key invalid');
        }
    }

    public function createToken(Request $request, $providerKey)
    {
        $apiKey = $request->headers->get($this->tokenName);
        if (!$apiKey) {
            throw new HttpException(403, 'No API key found: ' . $this->tokenName);
        }

        return new UserToken('anon.', $apiKey, $providerKey);
    }

    public function supportsToken(TokenInterface $token, $providerKey)
    {
        return $token instanceof UserToken && $token->getProviderKey() === $providerKey;
    }
}