<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\XAuthBundle\Service\Client;

use GuzzleHttp\Psr7\MultipartStream;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Client as CoreClient;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Request;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientData;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientDataDivision;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClient;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientData;
use Psr\Http\Message\ResponseInterface;

class Client implements UserProviderClient
{

    /**
     * @var CoreClient
     */
    private $client;

    /**
     * Client constructor.
     * @param CoreClient $client
     */
    public function __construct(CoreClient $client)
    {
        $this->client = $client;
    }

    /**
     * @param string $token
     * @return UserProviderClientData
     * @throws AccountNotFound
     */
    public function getAccount(string $token): UserProviderClientData
    {
        $request = new Request('GET', 'api/xauth/account', [
            'x-auth-token' => $token
        ]);

        try {
            $response = $this->client->call($request);
            $data = json_decode($response->getBody()->getContents());
            $divisions = [];
            foreach ($data->divisions as $divisionData) {
                $divisions[] = new ClientDataDivision($divisionData->uuid, $divisionData->name);
            }
            $currentDivision = new ClientDataDivision($data->division_current->uuid, $data->division_current->name);
            return new ClientData($data->account_uuid, $data->owner_uuid, $data->username, $data->email, $data->roles, $divisions,
                $currentDivision);
        } catch (RequestException $e) {
            throw new AccountNotFound('Account not found', 0, $e);
        }
    }

    /**
     * @param array $data
     * @return \Psr\Http\Message\ResponseInterface
     * @throws \IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException
     */
    public function login(array $data): ResponseInterface
    {

        $multiPartData = [];
        foreach ($data as $key => $value) {
            $multiPartData[] = [
                'name' => $key,
                'contents' => $value
            ];
        }
        $multiPart = new MultipartStream($multiPartData);
        $request = new Request('POST', 'api/xauth/login', [], $multiPart);
        return $this->client->call($request);
    }
}