<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\XAuthBundle\Controller;

use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class AuthenticationController extends Controller
{

    /**
     * @param Request $request
     * @return Response
     * @throws \InvalidArgumentException
     */
    public function loginAction(Request $request)
    {
        try {
            $response = $this->get('isset_bv_my_isset_x_auth.security.api.client')->login($request->request->all());
            return new Response($response->getBody(), $response->getStatusCode(), ['Content-Type' => 'application/json']);
        } catch (RequestException $e) {
            return new Response($e->getBody(), $e->getHttpCode(), ['Content-Type' => 'application/json']);
        }
    }

}