<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenCacheBundle\DependencyInjection;

use IssetBV\CacheBundle\DependencyInjection\IssetBVCacheExtension;
use IssetBV\MyIsset\TokenBundle\DependencyInjection\MyIssetTokenExtension;
use IssetBV\MyIsset\TokenBundle\Service\Security\TokenUserProviderClientInterface;
use IssetBV\MyIsset\TokenCacheBundle\Service\Security\CacheUserProviderClient;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Parameter;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetTokenCacheExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);
        if (null !== $config['connection']) {
            $writeID = IssetBVCacheExtension::CACHE_INSTANCE_PREFIX . ($config['connection_write'] ?? $config['connection']);
            $client = $container->register(CacheUserProviderClient::class);
            $client->setAutowired(true);
            $client->setArgument('$cacheRead', new Reference(IssetBVCacheExtension::CACHE_INSTANCE_PREFIX . $config['connection']));
            $client->setArgument('$cacheWrite', new Reference($writeID));
            $client->setArgument('$platform', new Parameter(MyIssetTokenExtension::PLATFORM_PARAMETER));
            $client->addTag(TokenUserProviderClientInterface::TAG);
        }
    }

    public function getAlias(): string
    {
        return 'myisset_token_cache';
    }
}
