<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenCacheBundle\DependencyInjection;

use IssetBV\MyIsset\CoreBundle\DependencyInjection\ConfigurationAddInterface;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface, ConfigurationAddInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root($this->getRootNode());
        $children = $rootNode->children();
        $this->addConfig($children);
        $children->end();

        return $treeBuilder;
    }

    public function addToNode(ArrayNodeDefinition $nodeDefinition)
    {
        $node = $nodeDefinition
            ->children()
            ->arrayNode($this->getNode())
            ->children();

        $this->addConfig($node);

        $node->end()
            ->end()
            ->end();
    }

    public function getNode(): string
    {
        return 'token_cache';
    }

    public function getRootNode(): string
    {
        return 'myisset_token_cache';
    }

    private function addConfig(NodeBuilder $node)
    {
        $node->scalarNode('connection')->defaultNull()->end();
        $node->scalarNode('connection_write')->defaultNull()->end();
    }
}
