<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenCacheBundle\Service\Security;

use IssetBV\CacheBundle\Service\CacheInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientDataGenerator;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountWillNotBeFound;
use IssetBV\MyIsset\TokenBundle\Service\Security\TokenUserProviderClientInterface;

class CacheUserProviderClient implements TokenUserProviderClientInterface
{
    const TOKEN_PREFIX = 'myisset_token_';
    const TOKEN_MISSING_IDENTIFIER = 'missing';
    const TOKEN_MISSING_TIME = 3600;
    /**
     * @var CacheInterface
     */
    private $cache;
    /**
     * @var ClientDataGenerator
     */
    private $clientDataGenerator;
    /**
     * @var string
     */
    private $tokenPrefix;

    public function __construct(CacheInterface $cache, ClientDataGenerator $clientDataGenerator, string $platform)
    {
        $this->cache = $cache;
        $this->clientDataGenerator = $clientDataGenerator;
        $this->tokenPrefix = self::TOKEN_PREFIX . $platform . '_';
    }

    /**
     * @param string $token
     *
     * @throws AccountNotFound
     * @throws AccountWillNotBeFound
     *
     * @return ClientDataInterface
     */
    public function getAccount(string $token): ClientDataInterface
    {
        $data = $this->cache->get($this->tokenPrefix . $token);
        if (null === $data) {
            throw AccountNotFound::create('account not found');
        }

        if (self::TOKEN_MISSING_IDENTIFIER === $data) {
            throw new AccountWillNotBeFound('account will not found');
        }

        return $this->clientDataGenerator->fromString($data);
    }

    public function missing(string $token)
    {
        $key = $this->tokenPrefix . $token;
        $this->cache->set($key, self::TOKEN_MISSING_IDENTIFIER);
        $this->cache->expireSeconds($key, self::TOKEN_MISSING_TIME);
    }

    public static function getWeight(): int
    {
        return 400;
    }
}
