<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountWillNotBeFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientInterface;

class UserProviderClient implements UserProviderClientInterface
{
    /**
     * @var TokenUserProviderClientInterface[]
     */
    private $providers = [];
    private $sorted = false;

    /**
     * @param string $token
     *
     * @throws AccountNotFound
     *
     * @return ClientDataInterface
     */
    public function getAccount(string $token): ClientDataInterface
    {
        $providers = $this->getProviders();
        foreach ($providers as $provider) {
            try {
                return $provider->getAccount($token);
            } catch (AccountWillNotBeFound $accountWillNotBeFound) {
                throw $accountWillNotBeFound;
            } catch (AccountNotFound $accountNotFound) {
                continue;
            }
        }
        foreach ($providers as $provider) {
            $provider->missing($token);
        }
        throw AccountNotFound::create('Account not found');
    }

    /**
     * @return TokenUserProviderClientInterface[]
     */
    public function getProviders(): array
    {
        if (!$this->sorted) {
            ksort($this->providers);
            $this->sorted = true;
        }

        return $this->providers;
    }

    public function add(TokenUserProviderClientInterface $userProviderClient)
    {
        $this->providers[$userProviderClient::getWeight()] = $userProviderClient;
    }
}
