<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenBundle\Service\Client;

use IssetBV\Http\Client\ClientInterface;
use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProvider;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientDataGenerator;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use IssetBV\MyIsset\TokenBundle\Service\Security\TokenUserProviderClientInterface;

class Client implements TokenUserProviderClientInterface
{
    /**
     * @var ClientInterface
     */
    private $client;
    /**
     * @var MyIssetUrlProvider
     */
    private $myIssetUrlProvider;
    /**
     * @var string
     */
    private $platform;
    /**
     * @var ClientDataGenerator
     */
    private $clientDataGenerator;

    public function __construct(
        ClientInterface $client,
        MyIssetUrlProvider $myIssetUrlProvider,
        ClientDataGenerator $clientDataGenerator,
        string $platform
    ) {
        $this->client = $client;
        $this->myIssetUrlProvider = $myIssetUrlProvider;
        $this->platform = $platform;
        $this->clientDataGenerator = $clientDataGenerator;
    }

    /**
     * @param string $token
     *
     * @throws AccountNotFound
     *
     * @return ClientDataInterface
     */
    public function getAccount(string $token): ClientDataInterface
    {
        $url = $this->myIssetUrlProvider->getWithBaseUrl('/api/token/v1/account');

        $request = $this->client->create('GET', $url, [
            'x-token-auth' => $token,
            'x-token-platform' => $this->platform,
        ]);

        $response = $this->client->call($request);

        return $this->clientDataGenerator->fromResponse($response);
    }

    public function missing(string $token)
    {
        // do nothing
    }

    public static function getWeight(): int
    {
        return 500;
    }
}
