<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenBundle\DependencyInjection;

use IssetBV\MyIsset\TokenBundle\Service\Client\Client;
use IssetBV\MyIsset\TokenBundle\Service\Security\TokenUserProviderClientInterface;
use IssetBV\MyIsset\TokenBundle\Service\Security\UserProvider;
use IssetBV\MyIsset\TokenBundle\Service\Security\UserProviderClient;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetTokenExtension extends Extension
{
    const PLATFORM_PARAMETER = 'myisset_token_platform';

    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $container->setParameter(self::PLATFORM_PARAMETER, $config['platform']);
        $client = $container->getDefinition(Client::class);
        $client->setAutowired(true);
        $client->setArgument('$platform', $config['platform']);
        $client->addTag(TokenUserProviderClientInterface::TAG);

        $userProviderClient = $container->findDefinition(UserProviderClient::class);
        $userProviderClient->setAutowired(true);

        $userProvider = $container->getDefinition(UserProvider::class);
        $userProvider->setAutowired(true);
        $userProvider->setArgument('$userProviderClient', new Reference(UserProviderClient::class));
    }

    public function getAlias(): string
    {
        return 'myisset_token';
    }
}
