<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenBundle\DependencyInjection;

use IssetBV\MyIsset\CoreBundle\DependencyInjection\ConfigurationAddInterface;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface, ConfigurationAddInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root($this->getRootNode());
        $children = $rootNode->children();
        $this->addConfig($children);
        $children->end();

        return $treeBuilder;
    }

    public function addToNode(ArrayNodeDefinition $nodeDefinition)
    {
        $node = $nodeDefinition
            ->children()
            ->arrayNode($this->getNode())
            ->isRequired()
            ->children();

        $this->addConfig($node);

        $node->end()
            ->end()
            ->end();
    }

    public function getNode(): string
    {
        return 'token';
    }

    public function getRootNode(): string
    {
        return 'myisset_token';
    }

    private function addConfig(NodeBuilder $node)
    {
        $node->scalarNode('platform')->isRequired()->end();
    }
}
