<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Http\Authentication\SimplePreAuthenticatorInterface;

class UserAuthenticator implements SimplePreAuthenticatorInterface
{
    /**
     * @var string
     */
    private $token;

    public function __construct(string $token = 'x-token-auth')
    {
        $this->token = $token;
    }

    public function authenticateToken(TokenInterface $token, UserProviderInterface $userProvider, $providerKey): UserToken
    {
        $credentials = $token->getCredentials();

        try {
            $user = $userProvider->loadUserByUsername($credentials);
        } catch (AccountNotFound $e) {
            throw new HttpException(401, 'API token invalid');
        }

        $return = new UserToken($user, $credentials, $providerKey, $user->getRoles());
        $return->setAuthenticated(true);

        return $return;
    }

    public function createToken(Request $request, $providerKey): UserToken
    {
        if (!$request->headers->has($this->token)) {
            throw new HttpException(401, "API token not found [$this->token]");
        }

        return new UserToken('anon.', $request->headers->get($this->token), $providerKey);
    }

    public function supportsToken(TokenInterface $token, $providerKey): bool
    {
        return $token instanceof UserToken && $token->getProviderKey() === $providerKey;
    }
}
