<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\TokenBundle\DependencyInjection\Compiler;

use IssetBV\MyIsset\TokenBundle\Service\Security\TokenUserProviderClientInterface;
use IssetBV\MyIsset\TokenBundle\Service\Security\UserProviderClient;
use LogicException;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class TokenProviderCompilerPass implements CompilerPassInterface
{
    /**
     * {@inheritdoc}
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $tag = UserProviderClient::class;
        if (!$container->hasDefinition($tag)) {
            throw new LogicException('tag not found ' . $tag);
        }

        $definition = $container->getDefinition($tag);

        $taggedServices = $container->findTaggedServiceIds(TokenUserProviderClientInterface::TAG);
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [new Reference($id)]);
        }
    }
}
