<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\MyIsset\CoreBundle\Entity\Division;
use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\PlatformBundle\Service\Client\TokenInterface;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MyIsset\PlatformBundle\Repository\TokenRepository")
 * @ORM\Table(name="myisset_platform_tokens")
 */
class Token implements TokenInterface
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    /**
     * @var User
     * @ORM\ManyToOne(targetEntity="IssetBV\MyIsset\CoreBundle\Entity\User")
     * @ORM\JoinColumn(nullable=false, onDelete="cascade")
     */
    private $user;
    /**
     * @var Division
     * @ORM\ManyToOne(targetEntity="IssetBV\MyIsset\CoreBundle\Entity\Division")
     * @ORM\JoinColumn(nullable=false, onDelete="cascade")
     */
    private $division;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=false)
     */
    private $platform;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=false)
     */
    private $token;
    /**
     * @var DateTime
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    public function __construct(User $user, Division $division, string $platform, string $token)
    {
        $this->user = $user;
        $this->division = $division;
        $this->platform = $platform;
        $this->token = $token;
        $this->dateCreated = new DateTime();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return User
     */
    public function getUser(): User
    {
        return $this->user;
    }

    /**
     * @return Division
     */
    public function getDivision(): Division
    {
        return $this->division;
    }

    /**
     * @return string
     */
    public function getPlatform(): string
    {
        return $this->platform;
    }

    /**
     * @return string
     */
    public function getToken(): string
    {
        return $this->token;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated(): DateTime
    {
        return $this->dateCreated;
    }
}
