<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\DependencyInjection;

use IssetBV\MyIsset\PlatformBundle\Service\Client\PlatformClient;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetPlatformExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $platformClient = $container->register(PlatformClient::class);
        $platformClient->setAutowired(true);
        $platformClient->setPublic(false);
        $platformClient->setArgument('$platformToken', $config['platform_token']);
    }

    public function getAlias()
    {
        return 'myisset_platform';
    }
}
