<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Template\Remote;

class RemoteGoogleDrive extends RemoteAbstract
{
    /**
     * @var string
     */
    private $path;
    /**
     * @var string
     */
    private $authToken;
    /**
     * @var string
     */
    private $authAdditionToken;
    /**
     * @var string
     */
    private $url;
    /**
     * @var string
     */
    private $location;

    /**
     * @param int $remoteId
     * @param string $name
     * @param string $type
     * @param string $path
     * @param string $authToken
     * @param string $authAdditionToken
     * @param string $url
     * @param string $location
     */
    public function __construct(
        int $remoteId,
        string $name,
        string $type,
        string $path = '',
        string $authToken = '',
        string $authAdditionToken = '',
        string $url = '',
        string $location = ''
    ) {
        parent::__construct($remoteId, $name, $type);

        $this->path = $path;
        $this->authToken = $authToken;
        $this->authAdditionToken = $authAdditionToken;
        $this->url = $url;
        $this->location = $location;
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'id' => $this->getRemoteId(),
            'name' => $this->getName(),
            'type' => $this->getType(),
            'path' => $this->path,
            'authToken' => $this->authToken,
            'authAdditionToken' => $this->authAdditionToken,
            'url' => $this->url,
            'location' => $this->location,
        ];
    }
}
