<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\Division;
use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\PlatformBundle\Entity\Token;

class TokenRepository extends EntityRepository
{
    public function fetchFor(User $user, Division $division, string $platform)
    {
        $token = $this->findOneBy([
            'user' => $user,
            'division' => $division,
            'platform' => $platform,
        ]);

        return $token instanceof Token ? $token : null;
    }
}
