<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Client;

use IssetBV\MyIsset\PlatformBundle\Template\XAuth\Token;

class XAuthClient
{
    const PLATFORM_HATCHERY = 'hatchery';
    const PLATFORM_VIDEO_ARCHIVE = 'video-archive';
    const PLATFORM_CONVERTER = 'converter';
    const PLATFORM_PUBLISHER = 'publisher';

    /**
     * @var PlatformClient
     */
    private $platformClient;

    public function __construct(PlatformClient $platformClient)
    {
        $this->platformClient = $platformClient;
    }

    /**
     * @param string $accountUuid
     * @param string $divisionUuid
     * @param string $platformName
     *
     * @throws PlatformClientException
     *
     * @return Token
     */
    public function getApiKey(string $accountUuid, string $divisionUuid, string $platformName): Token
    {
        $response = $this->platformClient->call(
            'GET',
            'api/platform/xauth/api/key',
            [
                'x-account-uuid' => $accountUuid,
                'x-division-uuid' => $divisionUuid,
                'x-platform' => $platformName,
            ]
        );

        if (200 !== $response->getStatusCode()) {
            throw PlatformClientException::create('Account not found', $response);
        }

        return new Token(json_decode((string) $response->getBody())->token);
    }
}
