<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Client;

use DateTime;
use IssetBV\MyIsset\PlatformBundle\Template\Credits\Balance;

class CreditsClient
{
    /**
     * @var PlatformClient
     */
    private $platformClient;

    public function __construct(PlatformClient $platformClient)
    {
        $this->platformClient = $platformClient;
    }

    public function getUsage(string $accountUuid, string $divisionUuid, DateTime $date = null)
    {
        $url = 'api/platform/usage';

        if (null !== $date) {
            $url .= '?date=' . $date->format('Y-m-d');
        }

        $response = $this->platformClient->call(
            'GET',
            $url,
            [
                'x-account-uuid' => $accountUuid,
                'x-division-uuid' => $divisionUuid,
            ]
        );

        if (200 !== $response->getStatusCode()) {
            throw PlatformClientException::create('Usage not found', $response);
        }

        return json_decode((string) $response->getBody());
    }

    public function getBalance(string $accountUuid, string $divisionUuid): Balance
    {
        $response = $this->platformClient->call(
            'GET',
            'api/platform/balance',
            [
                'x-account-uuid' => $accountUuid,
                'x-division-uuid' => $divisionUuid,
            ]
        );

        if (200 !== $response->getStatusCode()) {
            throw PlatformClientException::create('Bad request', $response);
        }

        $data = json_decode((string) $response->getBody());

        $balance = property_exists($data, 'balance') ? (int) $data->balance : 0;

        return new Balance($balance);
    }
}
