<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Client;

use IssetBV\Http\Client\ClientInterface;
use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProviderInterface;
use Psr\Http\Message\ResponseInterface;

class PlatformClient
{
    /**
     * @var ClientInterface
     */
    private $client;
    /**
     * @var string
     */
    private $platformToken;
    /**
     * @var string
     */
    private $platformHeader;
    /**
     * @var MyIssetUrlProviderInterface
     */
    private $myIssetUrlProvider;

    public function __construct(
        MyIssetUrlProviderInterface $myIssetUrlProvider,
        ClientInterface $client,
        string $platformToken,
        string $platformHeader = 'x-my-platform'
    ) {
        $this->client = $client;
        $this->platformToken = $platformToken;
        $this->platformHeader = $platformHeader;
        $this->myIssetUrlProvider = $myIssetUrlProvider;
    }

    public function call(
        string $method,
        string $uri,
        array $headers = [],
        $body = null
    ): ResponseInterface {
        $headers[$this->platformHeader] = $this->platformToken;
        $headers['Content-Type'] = 'application/json';

        $url = $this->myIssetUrlProvider->getWithBaseUrl($uri);
        $request = $this->client->create($method, $url, $headers, $body);

        return $this->client->call($request);
    }
}
