<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Template\Remote;

class RemoteYoutube extends RemoteAbstract
{
    /**
     * @var string
     */
    private $authToken;
    /**
     * @var string
     */
    private $authAdditionToken;
    /**
     * @var string
     */
    private $url;

    public function __construct(
        int $remoteId,
        string $name,
        string $type,
        string $authToken = '',
        string $authAdditionToken = '',
        string $url = ''
    ) {
        parent::__construct($remoteId, $name, $type);

        $this->authToken = $authToken;
        $this->authAdditionToken = $authAdditionToken;
        $this->url = $url;
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'id' => $this->getRemoteId(),
            'name' => $this->getName(),
            'type' => $this->getType(),
            'authToken' => $this->authToken,
            'authAdditionToken' => $this->authAdditionToken,
            'url' => $this->url,
        ];
    }

    /**
     * @return string
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }

    /**
     * @return string
     */
    public function getAuthAdditionToken()
    {
        return $this->authAdditionToken;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }
}
