<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Template\Remote;

class RemoteData
{
    /**
     * @param array $remotes
     *
     * @throws RemoteDataException
     *
     * @return Remote[]
     */
    public static function fromArray(array $remotes): array
    {
        $remotesReturn = [];
        foreach ($remotes as $remote) {
            $remotesReturn[] = self::fromList($remote);
        }

        return $remotesReturn;
    }

    /**
     * @param $remote
     *
     * @throws RemoteDataException
     *
     * @return Remote
     */
    public static function fromList($remote): Remote
    {
        switch ($remote->type) {
            case 'ftp':
                return new RemoteFtp($remote->id, $remote->name, $remote->type);
            case 'youtube':
                return new RemoteYoutube($remote->id, $remote->name, $remote->type);
            case 'amazon':
                return new RemoteAmazon($remote->id, $remote->name, $remote->type);
            case 'googledrive':
                return new RemoteGoogleDrive($remote->id, $remote->name, $remote->type);
            case 'dropbox':
                return new RemoteDropbox($remote->id, $remote->name, $remote->type);
            default:
                throw new RemoteDataException('Type not supported: ' . $remote->type);
        }
    }

    /**
     * @param int $remoteId
     * @param $details
     *
     * @throws RemoteDataException
     *
     * @return Remote
     */
    public static function fromDetails(int $remoteId, $details): Remote
    {
        switch ($details->type) {
            case 'ftp':
                return new RemoteFtp(
                    $remoteId,
                    $details->name,
                    $details->type,
                    $details->host,
                    (string) $details->path,
                    $details->user,
                    $details->password,
                    $details->location,
                    $details->url
                );
            case 'youtube':
                return new RemoteYoutube(
                    $remoteId,
                    $details->name,
                    $details->type,
                    $details->authToken,
                    $details->authAdditionToken,
                    $details->url
                );
            case 'amazon':
                return new RemoteAmazon(
                    $remoteId,
                    $details->name,
                    $details->type,
                    $details->path,
                    $details->authToken,
                    $details->authAdditionToken,
                    $details->url,
                    $details->location
                );
            case 'googledrive':
                return new RemoteGoogleDrive(
                    $remoteId,
                    $details->name,
                    $details->type,
                    (string) $details->path,
                    $details->authToken,
                    $details->authAdditionToken,
                    $details->url,
                    $details->location
                );
            case 'dropbox':
                return new RemoteDropbox(
                    $remoteId,
                    $details->name,
                    $details->type,
                    $details->path,
                    $details->authToken,
                    $details->authAdditionToken,
                    $details->url,
                    $details->location
                );
            default:
                throw new RemoteDataException('Type not supported: ' . $details->type);
        }
    }
}
