<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Data;

class RemoteData
{
    public static function fromList($remote)
    {
        switch ($remote->type) {
            case 'ftp':
                return new RemoteFtp($remote->id, $remote->name, $remote->type);
            case 'youtube':
                return new RemoteYoutube($remote->id, $remote->name, $remote->type);
            case 'amazon':
                return new RemoteAmazon($remote->id, $remote->name, $remote->type);
            case 'googledrive':
                return new RemoteGoogleDrive($remote->id, $remote->name, $remote->type);
            case 'dropbox':
                return new RemoteDropbox($remote->id, $remote->name, $remote->type);
            default:
                throw new \LogicException('Type not supported: ' . $remote->type);
        }
    }

    public static function fromDetails(int $remoteId, $details)
    {
        switch ($details->type) {
            case 'ftp':
                return new RemoteFtp($remoteId, $details->name, $details->type, $details->host, (string)$details->path, $details->user, $details->password, $details->location, $details->url);
            case 'youtube':
                return new RemoteYoutube($remoteId, $details->name, $details->type, $details->authToken, $details->authAdditionToken, $details->url);
            case 'amazon':
                return new RemoteAmazon($remoteId, $details->name, $details->type, $details->path, $details->authToken, $details->authAdditionToken, $details->url, $details->location);
            case 'googledrive':
                return new RemoteGoogleDrive($remoteId, $details->name, $details->type, $details->path, $details->authToken, $details->authAdditionToken, $details->url, $details->location);
            case 'dropbox':
                return new RemoteDropbox($remoteId, $details->name, $details->type, $details->path, $details->authToken, $details->authAdditionToken, $details->url, $details->location);
            default:
                throw new \LogicException('Type not supported: ' . $details->type);
        }
    }
}
