<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Data;

abstract class RemoteAbstract implements Remote
{
    /**
     * @var int
     */
    private $remoteId;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $type;

    /**
     * @param int    $remoteId
     * @param string $name
     * @param string $type
     */
    public function __construct(int $remoteId, string $name, string $type)
    {
        $this->remoteId = $remoteId;
        $this->name = $name;
        $this->type = $type;
    }

    /**
     * @return int
     */
    public function getRemoteId()
    {
        return $this->remoteId;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
}
