<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Client;

use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Client as CoreClient;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Request;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use RuntimeException;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

class Xauth
{
    /**
     * @var CoreClient
     */
    private $client;
    /**
     * @var string
     */
    private $token;

    /**
     * @param CoreClient $client
     * @param string     $token
     */
    public function __construct(CoreClient $client, string $token)
    {
        $this->client = $client;
        $this->token = $token;
    }

    /**
     * @param string $accountUuid
     * @param string $divisionUuid
     * @param string $platform
     *
     * @throws RuntimeException
     * @throws BadRequestHttpException
     *
     * @return string
     */
    public function getApiKey(string $accountUuid, string $divisionUuid, string $platform)
    {
        $request = new Request('GET', 'api/platform/xauth/api/key', [
            'x-my-platform' => $this->token,
            'x-account-uuid' => $accountUuid,
            'x-division-uuid' => $divisionUuid,
            'x-platform' => $platform,
        ]);

        try {
            $response = $this->client->call($request);

            return json_decode($response->getBody()->getContents())->token;
        } catch (RequestException $e) {
            throw new BadRequestHttpException('Account not found');
        }
    }
}
