<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Data;

class RemoteFtp extends RemoteAbstract implements Remote
{
    /**
     * @var string
     */
    private $host;
    /**
     * @var string
     */
    private $path;
    /**
     * @var string
     */
    private $user;
    /**
     * @var string
     */
    private $password;
    /**
     * @var string
     */
    private $location;
    /**
     * @var string
     */
    private $url;

    /**
     * @param int    $remoteId
     * @param string $name
     * @param string $type
     * @param string $host
     * @param string $path
     * @param string $user
     * @param string $password
     * @param string $location
     * @param string $url
     */
    public function __construct(
        int $remoteId,
        string $name,
        string $type,
        string $host = '',
        string $path = '',
        string $user = '',
        string $password = '',
        string $location = '',
        string $url = ''
    ) {
        parent::__construct($remoteId, $name, $type);
        $this->host = $host;
        $this->path = $path;
        $this->user = $user;
        $this->password = $password;
        $this->location = $location;
        $this->url = $url;
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'id' => $this->getRemoteId(),
            'name' => $this->getName(),
            'type' => $this->getType(),
            'host' => $this->host,
            'path' => $this->path,
            'user' => $this->user,
            'password' => $this->password,
            'location' => $this->location,
            'url' => $this->url,
        ];
    }

    /**
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }
}
