<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\PlatformBundle\Service\Client;

use DateTime;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Client as CoreClient;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Request;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use IssetBV\MyIsset\PlatformBundle\Service\Data\Remote;
use RuntimeException;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

class Credits
{
    /**
     * @var CoreClient
     */
    private $client;
    /**
     * @var string
     */
    private $token;

    /**
     * @param CoreClient $client
     * @param string     $token
     */
    public function __construct(CoreClient $client, string $token)
    {
        $this->client = $client;
        $this->token = $token;
    }

    /**
     * @param string $accountUuid
     * @param string $divisionUuid
     *
     * @throws RequestException
     * @throws BadRequestHttpException
     * @throws RuntimeException
     *
     * @return Remote[]
     */
    public function getUsage(string $accountUuid, string $divisionUuid, DateTime $date = null)
    {
        $url = 'api/platform/usage';
        if (null !== $date) {
            $url .= ('?date=' . $date->format('Y-m-d'));
        }

        $request = new Request('GET', $url, [
            'x-my-platform' => $this->token,
            'x-account-uuid' => $accountUuid,
            'x-division-uuid' => $divisionUuid,
        ]);

        try {
            /* todo: usage error */
            $response = $this->client->call($request);

            return json_decode($response->getBody()->getContents());
        } catch (RequestException $e) {
            throw new BadRequestHttpException('Usage not found');
        }
    }

    public function getBalance(string $accountUuid, string $divisionUuid)
    {
        $request = new Request('GET', 'api/platform/balance', [
            'x-my-platform' => $this->token,
            'x-account-uuid' => $accountUuid,
            'x-division-uuid' => $divisionUuid,
        ]);

        try {
            $response = $this->client->call($request);
            $data = json_decode($response->getBody()->getContents());
            if (property_exists($data, 'balance')) {
                return $data->balance;
            }

            return 0;
        } catch (RequestException $e) {
            throw new BadRequestHttpException('Account not found');
        }
    }
}
