<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\OAuthBundle\Service\Client\Client;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Data\LoginToken;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Exception\TokenNotCreatedException;
use Symfony\Component\Security\Core\Encoder\EncoderFactoryInterface;
use Symfony\Component\Security\Core\Encoder\PasswordEncoderInterface;

class UserLoginTokenGenerator
{
    /**
     * @var PasswordEncoderInterface
     */
    private $passwordEncoder;
    /**
     * @var Client
     */
    private $client;

    /**
     * UserLoginTokenGenerator constructor.
     *
     * @param EncoderFactoryInterface $encoderFactory
     * @param Client $client
     */
    public function __construct(EncoderFactoryInterface $encoderFactory, Client $client)
    {
        $this->passwordEncoder = $encoderFactory->getEncoder(self::class);
        $this->client = $client;
    }

    /**
     * @param string $publicKey
     * @param string $privateKey
     *
     * @throws TokenNotCreatedException
     *
     * @return LoginToken
     */
    public function generate(string $publicKey, string $privateKey): LoginToken
    {
        $salt = time() . '_' . base64_encode(random_bytes(64));
        $hash = $this->passwordEncoder->encodePassword($publicKey . $privateKey . $salt, $salt);

        return $this->client->getLoginToken($publicKey, $salt, $hash);
    }
}
