<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\OAuthBundle\Service\Security\RememberMe\TokenBasedRememberMeService;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\RememberMeToken;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;

class RememberMe
{
    /**
     * @var ContainerInterface
     */
    private $container;

    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    public function addRememberMe(
        TokenInterface $token,
        Request $request,
        Response $response
    ) {
        if (!($token instanceof UserToken)) {
            return;
        }

        $rememberMeService = $this->getTokenBasedRememberMeService($token->getProviderKey());
        if (null === $rememberMeService) {
            return;
        }

        $rememberMeService->loginSuccess($request, $response, $token);
    }

    /**
     * @param TokenInterface $token
     * @param Request $request
     * @param Response $response
     */
    public function logout(TokenInterface $token, Request $request, Response $response)
    {
        if (!($token instanceof RememberMeToken)) {
            return;
        }

        $rememberMeService = $this->getTokenBasedRememberMeService($token->getProviderKey());
        if (null === $rememberMeService) {
            return;
        }
        $rememberMeService->logout($request, $response, $token);
    }

    /**
     * @param string $providerKey
     *
     * @return TokenBasedRememberMeService|null
     */
    public function getTokenBasedRememberMeService(string $providerKey)
    {
        $key = TokenBasedRememberMeService::class . '.' . $providerKey;
        if (!$this->container->has($key)) {
            return null;
        }
        $rememberMeService = $this->container->get($key);
        if (!($rememberMeService instanceof TokenBasedRememberMeService)) {
            return null;
        }

        return $rememberMeService;
    }
}
