<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MyIsset\OAuthBundle\Repository\RememberMeTokenRepository")
 * @ORM\Table(name="myisset_remember_me_tokens")
 */
class RememberMeToken
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=false, unique=true)
     */
    private $token;
    /**
     * @var string
     * @ORM\Column(type="string", nullable=false)
     */
    private $apiKey;
    /**
     * @var DateTime
     * @ORM\Column( type="datetime", nullable=false)
     */
    private $dateCreated;
    /**
     * @var DateTime
     * @ORM\Column( type="datetime", nullable=false)
     */
    private $expires;

    public function __construct(string $apiKey, DateTime $expires)
    {
        $this->token = base64_encode(random_bytes(32));
        $this->dateCreated = new DateTime();
        $this->expires = $expires;
        $this->apiKey = $apiKey;
    }

    /**
     * @return string
     */
    public function getToken(): string
    {
        return $this->token;
    }

    /**
     * @return string
     */
    public function getApiKey(): string
    {
        return $this->apiKey;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated(): DateTime
    {
        return $this->dateCreated;
    }

    /**
     * @return DateTime
     */
    public function getExpires(): DateTime
    {
        return $this->expires;
    }

    public function isExpired(): bool
    {
        return $this->expires < new DateTime();
    }
}
