<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Command;

use IssetBV\MyIsset\OAuthBundle\Repository\RememberMeTokenRepository;
use Nette\Utils\DateTime;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class RememberMeCleanCommand extends Command
{
    const NAME = 'issetbv:myisset:oauth:remember_me:clean';
    /**
     * @var RememberMeTokenRepository
     */
    private $tokenRepository;

    public function __construct(string $name = null, RememberMeTokenRepository $tokenRepository)
    {
        parent::__construct($name);
        $this->tokenRepository = $tokenRepository;
    }

    protected function configure()
    {
        $this->setName(self::NAME);
        $this->setDescription('clean expired remember me tokens out of the database');
        $this->addOption('date-used', null, InputOption::VALUE_OPTIONAL, 'Time to use as check. default now');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $dateUsed = new DateTime($input->getOption('date-used') ?? 'now');
        $this->tokenRepository->removeForDate($dateUsed);
    }
}
